var plugins_bb40132b_638b_4a9f_b028_d3fe47acc8d1 = 
{
    "negative_items": function () {
	////// 设置某个物品的个数 //////
	items.prototype.setItem = function (itemId, itemNum) {
		itemNum = itemNum || 0;
		var itemCls = core.material.items[itemId].cls;
		if (itemCls == 'items') return;

		core.status.hero.items[itemCls][itemId] = itemNum;
		if (core.status.hero.items[itemCls][itemId] <= 0 && (itemId != "yellowKey" && itemId != "blueKey" && itemId != "redKey")) {
			delete core.status.hero.items[itemCls][itemId];
		}
		core.updateStatusBar();
	};

	////// 增加某个物品的个数 //////
	items.prototype.addItem = function (itemId, itemNum) {
		if (itemNum == null) itemNum = 1;
		var itemData = core.material.items[itemId];
		var itemCls = itemData.cls;
		if (itemCls == 'items') return;
		if (core.status.hero.items[itemCls][itemId] == null) {
			core.status.hero.items[itemCls][itemId] = 0;
		}
		core.status.hero.items[itemCls][itemId] += itemNum;
		if (core.status.hero.items[itemCls][itemId] <= 0 && (itemId != "yellowKey" && itemId != "blueKey" && itemId != "redKey")) {
			delete core.status.hero.items[itemCls][itemId];
		}
		// 永久道具只能有一个
		if (itemCls == 'constants' && core.status.hero.items[itemCls][itemId] > 1)
			core.status.hero.items[itemCls][itemId] = 1;
		core.updateStatusBar();
	};




	ui.prototype.drawTip = function (text, id, frame) {
		if (id == "yellowKey" || id == "blueKey" || id == "redKey") {
			return;
		}

		text = core.replaceText(text) || '';
		var realText = this._getRealContent(text);
		var one = {
			text: text,
			textX: 21,
			width: 26 + core.calWidth('data', realText, '16px Arial'),
			opacity: 0.1,
			stage: 1,
			frame: frame || 0,
			time: 0
		};
		if (id != null) {
			var info = core.getBlockInfo(id);
			if (info == null || !info.image || info.bigImage) {
				// 检查状态栏图标
				if (core.statusBar.icons[id] instanceof Image) {
					info = {
						image: core.statusBar.icons[id],
						posX: 0,
						posY: 0,
						height: 32
					};
				} else info = null;
			}
			if (info != null) {
				one.image = info.image;
				one.posX = info.posX;
				one.posY = info.posY;
				one.height = info.height;
				one.textX += 24;
				one.width += 24;
			}
		}
		core.animateFrame.tip = one;
	};
}
}